<?php

namespace App\Http\Controllers;

use App\Models\Petani;
use App\Models\Desa;
use App\Models\Poktan;
use App\Models\Kios;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Display the dashboard with statistics.
     */
    public function index()
    {
        // Get real statistics from database
        $stats = [
            'petani' => Petani::count(),
            'desa' => Desa::count(),
            'poktan' => Poktan::count(),
            'kios' => Kios::count(),
        ];

        return view('dashboard', compact('stats'));
    }

    /**
     * Get statistics data as JSON for AJAX requests.
     */
    public function getStats()
    {
        $stats = [
            'petani' => Petani::count(),
            'desa' => Desa::count(),
            'poktan' => Poktan::count(),
            'kios' => Kios::count(),
        ];

        return response()->json($stats);
    }
}

