<?php

namespace App\Http\Controllers;

use App\Models\Kios;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class KiosController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $kioss = Kios::paginate(10);
        return view('kios.index', compact('kioss'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('kios.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'kode_kios' => 'required|string|max:20|unique:kios,kode_kios',
            'nama_kios' => 'required|string|max:100',
            'alamat' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->route('kios.create')
                ->withErrors($validator)
                ->withInput();
        }

        Kios::create($request->all());

        return redirect()->route('kios.index')
            ->with('success', 'Kios berhasil ditambahkan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $kios = Kios::findOrFail($id);
        return view('kios.show', compact('kios'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $kios = Kios::findOrFail($id);
        return view('kios.edit', compact('kios'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $kios = Kios::findOrFail($id);
        
        $validator = Validator::make($request->all(), [
            'kode_kios' => ['required', 'string', 'max:20', Rule::unique('kios')->ignore($id, 'kode_kios')],
            'nama_kios' => 'required|string|max:100',
            'alamat' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->route('kios.edit', $id)
                ->withErrors($validator)
                ->withInput();
        }

        $kios->update($request->all());

        return redirect()->route('kios.index')
            ->with('success', 'Kios berhasil diperbarui.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $kios = Kios::findOrFail($id);
        $kios->delete();

        return redirect()->route('kios.index')
            ->with('success', 'Kios berhasil dihapus.');
    }
}
