<?php

namespace App\Imports;

use App\Models\Poktan;
use App\Models\Desa;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class PoktanImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnError, SkipsOnFailure
{
    use SkipsErrors, SkipsFailures;
    
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        // Cek apakah ID Poktan sudah ada
        $existingPoktan = Poktan::where('id_poktan', $row['id_poktan'])->first();
        
        if ($existingPoktan) {
            // Update data yang sudah ada
            $existingPoktan->update([
                'nama_poktan' => $row['nama_poktan'],
                'kode_desa' => $row['kode_desa'],
            ]);
            return null; // Return null karena kita hanya update
        }
        
        // Buat data baru
        return new Poktan([
            'id_poktan' => $row['id_poktan'],
            'nama_poktan' => $row['nama_poktan'],
            'kode_desa' => $row['kode_desa'],
        ]);
    }
    
    /**
     * @return array
     */
    public function rules(): array
    {
        return [
            'id_poktan' => 'required|string|max:20',
            'nama_poktan' => 'required|string|max:100',
            'kode_desa' => 'required|string|exists:desas,kode_desa',
        ];
    }

    /**
     * @return array
     */
    public function customValidationMessages()
    {
        return [
            'id_poktan.required' => 'ID Poktan wajib diisi.',
            'id_poktan.max' => 'ID Poktan maksimal 20 karakter.',
            'nama_poktan.required' => 'Nama Poktan wajib diisi.',
            'nama_poktan.max' => 'Nama Poktan maksimal 100 karakter.',
            'kode_desa.required' => 'Kode Desa wajib diisi.',
            'kode_desa.exists' => 'Kode Desa tidak valid. Pastikan kode desa sudah terdaftar di sistem.',
        ];
    }
}

