<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Kios extends Model
{
    use HasFactory;
    
    protected $table = 'kios';
    protected $primaryKey = 'kode_kios';
    protected $keyType = 'string';
    public $incrementing = false;
    
    protected $fillable = [
        'kode_kios',
        'nama_kios',
        'alamat',
    ];
    
    public function petanis()
    {
        return $this->hasMany(Petani::class, 'kode_kios', 'kode_kios');
    }
}