<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('petanis', function (Blueprint $table) {
            $table->string('alamat')->nullable()->after('nama_ibu_kandung');
            $table->string('no_hp', 15)->nullable()->after('alamat');
            $table->string('email')->nullable()->after('no_hp');
            $table->enum('jenis_kelamin', ['L', 'P'])->nullable()->after('email');
            $table->date('tanggal_lahir')->nullable()->after('jenis_kelamin');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('petanis', function (Blueprint $table) {
            $table->dropColumn([
                'alamat',
                'no_hp',
                'email',
                'jenis_kelamin',
                'tanggal_lahir'
            ]);
        });
    }
};