<x-guest-layout>
    <div class="text-center mb-6">
        <h2 class="text-3xl font-bold text-primary-custom mb-2">Selamat Datang</h2>
        <p class="text-gray-600">Silakan login untuk melanjutkan</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('login') }}" class="space-y-6">
        @csrf

        <!-- Email Address -->
        <div>
            <label for="email" class="block text-sm font-semibold text-gray-700 mb-2">
                Email
            </label>
            <input id="email" 
                   class="form-input-custom" 
                   type="email" 
                   name="email" 
                   value="{{ old('email') }}" 
                   required 
                   autofocus 
                   autocomplete="username"
                   placeholder="nama@email.com">
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div>
            <label for="password" class="block text-sm font-semibold text-gray-700 mb-2">
                Password
            </label>
            <input id="password" 
                   class="form-input-custom"
                   type="password"
                   name="password"
                   required 
                   autocomplete="current-password"
                   placeholder="Masukkan password">
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Remember Me -->
        <div class="flex items-center justify-between">
            <label for="remember_me" class="inline-flex items-center cursor-pointer">
                <input id="remember_me" 
                       type="checkbox" 
                       class="rounded border-gray-300 shadow-sm focus:ring-2 focus:ring-offset-2" 
                       style="color: var(--green-5);"
                       name="remember">
                <span class="ms-2 text-sm text-gray-600 font-medium">Ingat Saya</span>
            </label>

            @if (Route::has('password.request'))
                <a class="link-custom text-sm" href="{{ route('password.request') }}">
                    Lupa Password?
                </a>
            @endif
        </div>

        <div>
            <button type="submit" class="btn-primary-custom w-full text-center">
                Masuk
            </button>
        </div>

        @if (Route::has('register'))
            <div class="text-center pt-4 border-t border-gray-200">
                <p class="text-sm text-gray-600">
                    Belum punya akun? 
                    <a href="{{ route('register') }}" class="link-custom font-semibold">
                        Daftar Sekarang
                    </a>
                </p>
            </div>
        @endif
    </form>
</x-guest-layout>
