<x-app-layout>
    <link rel="stylesheet" href="{{ asset('css/modern-design.css') }}">
    <x-slot name="header">
        <div class="breadcrumbs">
            <a href="{{ route('dashboard') }}" class="breadcrumb-item">Dashboard</a>
            <span class="breadcrumb-separator">/</span>
            <a href="{{ route('desa.index') }}" class="breadcrumb-item">Data Desa</a>
            <span class="breadcrumb-separator">/</span>
            <span class="breadcrumb-active">Detail</span>
        </div>
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Detail Desa') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Informasi Desa</h3>
                    <div class="card-actions">
                        <a href="{{ route('desa.edit', $desa->kode_desa) }}" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                            </svg>
                            Edit
                        </a>
                        <a href="{{ route('desa.index') }}" class="btn btn-outline">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                            </svg>
                            Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="detail-container">
                        <div class="detail-group">
                            <h4 class="detail-label">Kode Desa</h4>
                            <p class="detail-value">{{ $desa->kode_desa }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Nama Desa</h4>
                            <p class="detail-value">{{ $desa->nama_desa }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Tanggal Registrasi</h4>
                            <p class="detail-value">{{ $desa->created_at ? $desa->created_at->format('d M Y H:i') : '-' }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Terakhir Diperbarui</h4>
                            <p class="detail-value">{{ $desa->updated_at ? $desa->updated_at->format('d M Y H:i') : '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-6">
                <div class="card-header">
                    <h3 class="card-title">Kelompok Tani di Desa Ini</h3>
                </div>
                <div class="card-body">
                    @if($desa->poktans->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="table-auto w-full">
                                <thead>
                                    <tr>
                                        <th class="px-4 py-2 text-left">ID Poktan</th>
                                        <th class="px-4 py-2 text-left">Nama Kelompok Tani</th>
                                        <th class="px-4 py-2 text-left">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($desa->poktans as $poktan)
                                        <tr>
                                            <td class="border px-4 py-2">{{ $poktan->id_poktan }}</td>
                                            <td class="border px-4 py-2">{{ $poktan->nama_poktan }}</td>
                                            <td class="border px-4 py-2">
                                                <a href="{{ route('poktan.show', $poktan->id_poktan) }}" class="btn btn-sm btn-outline">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="empty-state">
                            <div class="empty-state-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                            </div>
                            <h4>Belum ada kelompok tani di desa ini</h4>
                            <p>Kelompok tani yang terdaftar di desa ini akan muncul di sini</p>
                            <a href="{{ route('poktan.create') }}" class="btn btn-primary mt-4">Tambah Kelompok Tani Baru</a>
                        </div>
                    @endif
                </div>
            </div>

            <div class="card mt-6">
                <div class="card-header">
                    <h3 class="card-title">Petani di Desa Ini</h3>
                </div>
                <div class="card-body">
                    @if($desa->petanis->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="table-auto w-full">
                                <thead>
                                    <tr>
                                        <th class="px-4 py-2 text-left">Nama Penyuluh</th>
                                        <th class="px-4 py-2 text-left">No KTP</th>
                                        <th class="px-4 py-2 text-left">Kelompok Tani</th>
                                        <th class="px-4 py-2 text-left">Status</th>
                                        <th class="px-4 py-2 text-left">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($desa->petanis as $petani)
                                        <tr>
                                            <td class="border px-4 py-2">{{ $petani->nama_penyuluh }}</td>
                                            <td class="border px-4 py-2">{{ $petani->no_ktp }}</td>
                                            <td class="border px-4 py-2">{{ $petani->poktan->nama_poktan ?? '-' }}</td>
                                            <td class="border px-4 py-2">
                                                <span class="badge {{ $petani->status === 'aktif' ? 'badge-success' : 'badge-danger' }}">
                                                    {{ $petani->status === 'aktif' ? 'Aktif' : 'Tidak Aktif' }}
                                                </span>
                                            </td>
                                            <td class="border px-4 py-2">
                                                <a href="{{ route('petani.show', $petani->id) }}" class="btn btn-sm btn-outline">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="empty-state">
                            <div class="empty-state-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                </svg>
                            </div>
                            <h4>Belum ada petani di desa ini</h4>
                            <p>Petani yang terdaftar di desa ini akan muncul di sini</p>
                            <a href="{{ route('petani.create') }}" class="btn btn-primary mt-4">Tambah Petani Baru</a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>