<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }} - Sistem Informasi Pertanian</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Custom CSS -->
        <link href="{{ asset('css/auth-pages.css') }}" rel="stylesheet">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-900 antialiased">
        <div class="auth-background min-h-screen flex flex-col sm:justify-center items-center pt-6 sm:pt-0">
            <div class="fade-in">
                <a href="/" class="block">
                    <div class="logo-container">
                        <x-application-logo class="w-16 h-16" />
                    </div>
                </a>
                <h1 class="text-center mt-4 text-2xl font-bold text-primary-custom">
                    Sistem Informasi Pertanian
                </h1>
            </div>

            <div class="auth-card w-full sm:max-w-md mt-8 px-8 py-8 fade-in-up">
                {{ $slot }}
            </div>
            
            <p class="text-center text-sm text-gray-600 mt-6">
                &copy; {{ date('Y') }} Sistem Informasi Pertanian. All rights reserved.
            </p>
        </div>
    </body>
</html>
