<x-app-layout>
    <link rel="stylesheet" href="{{ asset('css/consistent-ui.css') }}">
    
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <nav class="breadcrumb" aria-label="breadcrumb">
                    <ol class="flex text-sm">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}" class="text-primary hover:text-primary-dark">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Data Petani</li>
                    </ol>
                </nav>
                <h2 class="font-semibold text-2xl text-gray-800 leading-tight mt-2">
                    {{ __('Data Petani') }}
                </h2>
            </div>
            <a href="{{ route('petani.create') }}" class="btn btn-primary flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
                Tambah Data Petani
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="card fade-in">
                <div class="card-header flex justify-between items-center">
                    <h3 class="text-lg font-medium text-gray-800">Daftar Data Petani</h3>
                    <div class="flex items-center gap-2">
                        <span class="text-sm text-gray-500">Total: {{ count($petanis) }} petani</span>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-6 flex flex-col md:flex-row justify-between items-center gap-4">
                        <div class="flex gap-2">
                            <a href="{{ route('petani.export') }}" class="btn btn-secondary flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                                </svg>
                                Export Excel
                            </a>
                            <button id="importBtn" class="btn btn-outline flex items-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                                </svg>
                                Import Excel
                            </button>
                        </div>
                        <div class="w-full md:w-1/3 relative">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                            <input type="text" id="searchInput" placeholder="Cari data petani..." class="form-control pl-10">
                        </div>
                    </div>

                    <!-- Import Form Modal -->
                    <div id="importModal" class="modal-backdrop hidden">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3 class="text-lg font-bold">Import Data Petani</h3>
                                <button type="button" id="closeImportModalX" class="text-gray-500 hover:text-gray-700">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form action="{{ route('petani.import') }}" method="POST" enctype="multipart/form-data" id="importForm">
                                    @csrf
                                    <div class="form-group">
                                        <label for="importFile" class="form-label">File Excel</label>
                                        <input type="file" name="file" id="importFile" class="form-control" required>
                                        <p class="text-xs text-gray-500 mt-1">Format file: .xlsx, .xls (max: 5MB)</p>
                                    </div>
                                    <div class="mt-4 p-3 bg-blue-50 rounded-md">
                                        <h4 class="font-semibold text-sm mb-2">Syarat dan Ketentuan Import Excel:</h4>
                                        <ul class="text-xs text-gray-600 list-disc pl-4 space-y-1">
                                            <li>Gunakan template yang disediakan untuk menghindari kesalahan format</li>
                                            <li>Kolom status harus diisi dengan nilai "belum_terinput" atau "sudah_terinput"</li>
                                            <li>Pastikan nomor KTP 16 digit dan tidak duplikat dengan data yang sudah ada</li>
                                            <li>Kode desa, ID poktan, dan kode kios harus sudah terdaftar di sistem</li>
                                            <li>Subsektor (opsional): tanaman_pangan, hortikultura, perkebunan, atau peternakan</li>
                                            <li>Kolom opsional: subsektor, komoditas, luas_lahan, status (default: belum_terinput)</li>
                                        </ul>
                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" id="closeImportModal" class="btn btn-outline">
                                    Batal
                                </button>
                                <button type="button" id="submitImport" class="btn btn-primary flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                                    </svg>
                                    Import
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th class="cursor-pointer" data-sort="nama_penyuluh">
                                        <div class="flex items-center gap-1">
                                            Nama
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 sort-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4" />
                                            </svg>
                                        </div>
                                    </th>
                                    <th>No KTP</th>
                                    <th class="cursor-pointer" data-sort="desa">
                                        <div class="flex items-center gap-1">
                                            Desa
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 sort-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4" />
                                            </svg>
                                        </div>
                                    </th>
                                    <th>Poktan</th>
                                    <th>Kios</th>
                                    <th class="cursor-pointer" data-sort="status">
                                        <div class="flex items-center gap-1">
                                            Status
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 sort-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4" />
                                            </svg>
                                        </div>
                                    </th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200" id="petaniTable">
                                @forelse ($petanis as $petani)
                                    <tr class="hover:bg-gray-50 transition-colors duration-150 ease-in-out">
                                        <td>{{ $petani->nama_penyuluh }}</td>
                                        <td>{{ $petani->no_ktp }}</td>
                                        <td>{{ $petani->desa->kode_desa ?? '-' }}</td>
                                        <td>{{ $petani->poktan->id_poktan ?? '-' }}</td>
                                        <td>{{ $petani->kios->kode_kios ?? '-' }}</td>
                                        <td>
                                            <span class="badge {{ $petani->status === 'sudah_terinput' ? 'badge-success' : 'badge-warning' }}">
                                                {{ $petani->status === 'sudah_terinput' ? 'Sudah Terinput' : 'Belum Terinput' }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="flex space-x-2">
                                                <a href="{{ route('petani.show', $petani->id) }}" class="btn btn-sm btn-outline flex items-center gap-1" title="Detail">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                    </svg>
                                                    <span class="hidden md:inline">Detail</span>
                                                </a>
                                                <a href="{{ route('petani.edit', $petani->id) }}" class="btn btn-sm btn-outline flex items-center gap-1" title="Edit">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                                    </svg>
                                                    <span class="hidden md:inline">Edit</span>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger flex items-center gap-1 delete-btn" 
                                                    data-id="{{ $petani->id }}" data-name="{{ $petani->nama_penyuluh }}" title="Hapus">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                                    </svg>
                                                    <span class="hidden md:inline">Hapus</span>
                                                </button>
                                                <form id="delete-form-{{ $petani->id }}" action="{{ route('petani.destroy', $petani->id) }}" method="POST" class="hidden">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7">
                                            <div class="empty-state py-8">
                                                <div class="empty-state-icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                                    </svg>
                                                </div>
                                                <h4 class="text-lg font-medium text-gray-800">Tidak ada data petani</h4>
                                                <p class="text-gray-500 mb-4">Silakan tambahkan data petani baru</p>
                                                <a href="{{ route('petani.create') }}" class="btn btn-primary">
                                                    Tambah Data Petani
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="mt-4 flex justify-between items-center">
                        <div class="text-sm text-gray-500">
                            Menampilkan {{ count($petanis) }} dari {{ count($petanis) }} data
                        </div>
                        <div class="flex gap-1">
                            <button class="btn btn-sm btn-outline disabled" id="prevPage">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                </svg>
                            </button>
                            <button class="btn btn-sm btn-outline disabled" id="nextPage">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Delete Confirmation Modal -->
            <div id="deleteModal" class="modal-backdrop hidden">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="text-lg font-bold">Konfirmasi Hapus</h3>
                        <button type="button" id="closeDeleteModalX" class="text-gray-500 hover:text-gray-700">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Apakah Anda yakin ingin menghapus data petani <span id="deletePetaniName" class="font-semibold"></span>?</p>
                        <p class="text-sm text-gray-500 mt-2">Tindakan ini tidak dapat dibatalkan dan semua data terkait akan dihapus secara permanen.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="closeDeleteModal" class="btn btn-outline">
                            Batal
                        </button>
                        <button type="button" id="confirmDelete" class="btn btn-danger flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                            </svg>
                            Hapus
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Import Modal
            const importBtn = document.getElementById('importBtn');
            const importModal = document.getElementById('importModal');
            const closeImportModal = document.getElementById('closeImportModal');
            const closeImportModalX = document.getElementById('closeImportModalX');
            const submitImport = document.getElementById('submitImport');
            const importForm = document.getElementById('importForm');
            
            // Pastikan modal import tidak terbuka secara otomatis saat halaman dimuat
            setTimeout(() => {
                if (importModal) {
                    importModal.style.display = 'none';
                    importModal.classList.add('hidden');
                    importModal.classList.remove('flex');
                }
            }, 0);

            importBtn.addEventListener('click', function(e) {
                e.preventDefault();
                importModal.style.display = '';
                importModal.classList.remove('hidden');
                importModal.classList.add('flex');
            });

            closeImportModal.addEventListener('click', function() {
                importModal.classList.add('hidden');
                importModal.classList.remove('flex');
            });

            closeImportModalX.addEventListener('click', function() {
                importModal.classList.add('hidden');
                importModal.classList.remove('flex');
            });

            submitImport.addEventListener('click', function() {
                importForm.submit();
            });

            // Delete Modal
            const deleteModal = document.getElementById('deleteModal');
            const deleteBtns = document.querySelectorAll('.delete-btn');
            const closeDeleteModal = document.getElementById('closeDeleteModal');
            const closeDeleteModalX = document.getElementById('closeDeleteModalX');
            const confirmDelete = document.getElementById('confirmDelete');
            const deletePetaniName = document.getElementById('deletePetaniName');
            let currentDeleteId = null;
            
            // Pastikan modal tidak terbuka secara otomatis saat halaman dimuat
            // Menggunakan setTimeout untuk memastikan ini dijalankan setelah semua kode lain
            setTimeout(() => {
                if (deleteModal) {
                    deleteModal.style.display = 'none';
                    deleteModal.classList.add('hidden');
                    deleteModal.classList.remove('flex');
                }
            }, 0);

            deleteBtns.forEach(btn => {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    currentDeleteId = this.dataset.id;
                    deletePetaniName.textContent = this.dataset.name;
                    deleteModal.style.display = '';
                    deleteModal.classList.remove('hidden');
                    deleteModal.classList.add('flex');
                });
            });

            closeDeleteModal.addEventListener('click', function() {
                deleteModal.classList.add('hidden');
                deleteModal.classList.remove('flex');
            });

            closeDeleteModalX.addEventListener('click', function() {
                deleteModal.classList.add('hidden');
                deleteModal.classList.remove('flex');
            });

            confirmDelete.addEventListener('click', function() {
                document.getElementById(`delete-form-${currentDeleteId}`).submit();
            });

            // Search functionality
            const searchInput = document.getElementById('searchInput');
            const petaniTable = document.getElementById('petaniTable');
            const rows = petaniTable.querySelectorAll('tr');

            searchInput.addEventListener('keyup', function() {
                const searchTerm = this.value.toLowerCase();
                
                rows.forEach(row => {
                    if (row.querySelector('td')) {
                        const text = row.textContent.toLowerCase();
                        if (text.includes(searchTerm)) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    }
                });
            });

            // Sorting functionality
            const sortableHeaders = document.querySelectorAll('th[data-sort]');
            
            sortableHeaders.forEach(header => {
                header.addEventListener('click', function() {
                    const sortBy = this.dataset.sort;
                    const isAscending = this.classList.contains('sort-asc');
                    
                    // Reset all headers
                    sortableHeaders.forEach(h => {
                        h.classList.remove('sort-asc', 'sort-desc');
                    });
                    
                    // Set current header sort direction
                    if (isAscending) {
                        this.classList.add('sort-desc');
                    } else {
                        this.classList.add('sort-asc');
                    }
                    
                    // Sort the table
                    const rowsArray = Array.from(rows).filter(row => row.querySelector('td'));
                    rowsArray.sort((a, b) => {
                        let aValue, bValue;
                        
                        if (sortBy === 'nama_penyuluh') {
                            aValue = a.cells[0].textContent;
                            bValue = b.cells[0].textContent;
                        } else if (sortBy === 'desa') {
                            aValue = a.cells[2].textContent;
                            bValue = b.cells[2].textContent;
                        } else if (sortBy === 'status') {
                            aValue = a.cells[5].textContent.trim();
                            bValue = b.cells[5].textContent.trim();
                        }
                        
                        if (isAscending) {
                            return bValue.localeCompare(aValue);
                        } else {
                            return aValue.localeCompare(bValue);
                        }
                    });
                    
                    // Reorder the table
                    rowsArray.forEach(row => {
                        petaniTable.appendChild(row);
                    });
                });
            });
        });
    </script>
</x-app-layout>