<x-app-layout>
    <link rel="stylesheet" href="{{ asset('css/modern-design.css') }}">
    <x-slot name="header">
        <div class="breadcrumbs">
            <a href="{{ route('dashboard') }}" class="breadcrumb-item">Dashboard</a>
            <span class="breadcrumb-separator">/</span>
            <a href="{{ route('poktan.index') }}" class="breadcrumb-item">Kelompok Tani</a>
            <span class="breadcrumb-separator">/</span>
            <span class="breadcrumb-active">Detail</span>
        </div>
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Detail Kelompok Tani') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Informasi Kelompok Tani</h3>
                    <div class="card-actions">
                        <a href="{{ route('poktan.edit', $poktan->id_poktan) }}" class="btn btn-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                            </svg>
                            Edit
                        </a>
                        <a href="{{ route('poktan.index') }}" class="btn btn-outline">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                            </svg>
                            Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="detail-container">
                        <div class="detail-group">
                            <h4 class="detail-label">ID Kelompok Tani</h4>
                            <p class="detail-value">{{ $poktan->id_poktan }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Nama Kelompok Tani</h4>
                            <p class="detail-value">{{ $poktan->nama_poktan }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Desa</h4>
                            <p class="detail-value">{{ $poktan->desa->nama_desa ?? '-' }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Tanggal Registrasi</h4>
                            <p class="detail-value">{{ $poktan->created_at ? $poktan->created_at->format('d M Y H:i') : '-' }}</p>
                        </div>
                        
                        <div class="detail-group">
                            <h4 class="detail-label">Terakhir Diperbarui</h4>
                            <p class="detail-value">{{ $poktan->updated_at ? $poktan->updated_at->format('d M Y H:i') : '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-6">
                <div class="card-header">
                    <h3 class="card-title">Daftar Petani dalam Kelompok Tani Ini</h3>
                </div>
                <div class="card-body">
                    @if($poktan->petanis->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="table-auto w-full">
                                <thead>
                                    <tr>
                                        <th class="px-4 py-2 text-left">Nama Penyuluh</th>
                                        <th class="px-4 py-2 text-left">No KTP</th>
                                        <th class="px-4 py-2 text-left">Desa</th>
                                        <th class="px-4 py-2 text-left">Status</th>
                                        <th class="px-4 py-2 text-left">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($poktan->petanis as $petani)
                                        <tr>
                                            <td class="border px-4 py-2">{{ $petani->nama_penyuluh }}</td>
                                            <td class="border px-4 py-2">{{ $petani->no_ktp }}</td>
                                            <td class="border px-4 py-2">{{ $petani->desa->nama_desa ?? '-' }}</td>
                                            <td class="border px-4 py-2">
                                                <span class="badge {{ $petani->status === 'aktif' ? 'badge-success' : 'badge-danger' }}">
                                                    {{ $petani->status === 'aktif' ? 'Aktif' : 'Tidak Aktif' }}
                                                </span>
                                            </td>
                                            <td class="border px-4 py-2">
                                                <a href="{{ route('petani.show', $petani->id) }}" class="btn btn-sm btn-outline">Detail</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="empty-state">
                            <div class="empty-state-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                </svg>
                            </div>
                            <h4>Belum ada petani dalam kelompok tani ini</h4>
                            <p>Petani yang terdaftar dalam kelompok tani ini akan muncul di sini</p>
                            <a href="{{ route('petani.create') }}" class="btn btn-primary mt-4">Tambah Petani Baru</a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>